```toml
[advisory]
id = "RUSTSEC-2018-0001"
package = "untrusted"
aliases = ["CVE-2018-20989", "GHSA-wq8f-46ww-6c2h"]
cvss = "CVSS:3.0/AV:N/AC:L/PR:N/UI:N/S:U/C:N/I:N/A:H"
date = "2018-06-21"
keywords = ["crash"]
url = "https://github.com/briansmith/untrusted/pull/20"

[versions]
patched = [">= 0.6.2"]
unaffected = []
```

# An integer underflow could lead to panic

A mistake in error handling in untrusted before 0.6.2 could lead to an integer
underflow and panic if a user of the crate didn't properly check for errors
returned by untrusted.

Combination of these two programming errors (one in untrusted and another by
user of this crate) could lead to a panic and maybe a denial of service of
affected software.

The error in untrusted is fixed in release 0.6.2 released 2018-06-21. It's also
advisable that users of untrusted check for their sources for cases where errors
returned by untrusted are not handled correctly.
