```toml
[advisory]
id = "RUSTSEC-2018-0007"
package = "trust-dns-proto"
aliases = ["CVE-2018-20994", "GHSA-369h-pjr2-6wrh"]
cvss = "CVSS:3.0/AV:N/AC:L/PR:N/UI:N/S:U/C:N/I:N/A:H"
date = "2018-10-09"
keywords = ["stack-overflow", "crash"]

[versions]
patched = [">= 0.4.3"]
```

# Stack overflow when parsing malicious DNS packet

There's a stack overflow leading to a crash when Trust-DNS's parses a
malicious DNS packet.

Affected versions of this crate did not properly handle parsing of DNS message
compression (RFC1035 section 4.1.4). The parser could be tricked into infinite
loop when a compression offset pointed back to the same domain name to be
parsed.

This allows an attacker to craft a malicious DNS packet which when consumed
with Trust-DNS could cause stack overflow and crash the affected software.

The flaw was corrected by trust-dns-proto 0.4.3 and upcoming 0.5.0 release.
