```toml
[advisory]
id = "RUSTSEC-2024-0339"
package = "tor-circmgr"
date = "2024-05-15"
url = "https://gitlab.torproject.org/tpo/core/arti/-/issues/1409"
keywords = ["tor", "privacy", "information-leak"]
aliases = ["CVE-2024-35312", "CVE-2024-35313", "GHSA-9328-gcfq-p269", "GHSA-c96h-cxx6-rmg9", "TROVE-2024-003"]
related = ["TROVE-2024-004"]

[versions]
patched = [">= 0.18.1"]
unaffected = ["< 0.18.0"]
```

# Tor path lengths too short when "Vanguards lite" configured

## Description

When building anonymizing circuits to or from an onion service with 
'lite' vanguards (the default) enabled, 
the circuit manager code would build the circuits with one hop too few.

## Impact

This makes users of this code more vulnerable to some kinds of traffic analysis
when they run or visit onion services.

## Vulnerable configurations and use cases

Arti configured with "vangaurds lite" is vulnerable;
this is the default.

Only users who make connections to Onion Services
(Tor Hidden Services) are affected.
Note, however, that when used as a browser proxy,
malicious web pages can typically make such connections.

## Mitigation

Enable the "full vanguards" feature.
This has some cost in terms of performance, reliability,
and impact on the Tor Network.

(Arti configured with "full vanguards" has a similar bug,
TROVE-2024-04,
so this will not deliver the full incressed security of "full vanguards";
but the security level of affected versions of Arti
configured with "full vanguards" still exceeds
the intended security level of the "vanguards lite" configuration.)

Alternatively,
preventing access to Tor Hidden Services will avoid the problem,
with corresponding loss of functionality.
This can be achieved in the Arti configuration file with:

```
[address_filter]
allow_onion_addrs = false
```

## Resolution

Rebuild `arti` (or other affected applications)
with a fixed version of `tor-circmgr`:
0.18.1 or later.

The fixed `tor-circmgr` is on crates.io and available in
[the upstream git repository](https://gitlab.torproject.org/tpo/core/arti)
at signed tag `arti-v1.2.3`.

### Note about older versions

Even though earlier versions are classified as "not affected",
this is because in those versions the Vanguards feature
is experimental, or absent.
Downgrading worsens security, rather than improving it.

## References

 * [arti#1409](https://gitlab.torproject.org/tpo/core/arti/-/issues/1409):
   the ticket in the Arti bugtracker.
 * [TROVE](https://gitlab.torproject.org/tpo/core/team/-/wikis/NetworkTeam/TROVE)
   Tor Project vulnerability database.
 * [arti#1400](https://gitlab.torproject.org/tpo/core/arti/-/issues/1400):
   the similar bug with the full vanguards feature.
