```toml
[advisory]
id = "RUSTSEC-2024-0005"
package = "threadalone"
date = "2024-01-07"
url = "https://github.com/cr0sh/threadalone/issues/1"
informational = "unsound"
aliases = ["GHSA-w59h-378f-2frm"]

[versions]
patched = [">= 0.2.1"]
```

# Unsound sending of non-Send types across threads

Affected versions can run the `Drop` impl of a non-Send type on a different
thread than it was created on.

The flaw occurs when a stderr write performed by the `threadalone` crate fails,
for example because stderr is redirected to a location on a filesystem that is
full, or because stderr is a pipe that has been closed by the reader.

Dropping a non-Send type on the wrong thread is unsound. If used with a type
such as a pthread-based `MutexGuard`, [the consequence is undefined
behavior][mutexguard]. If used with `Rc`, there would be a data race on the
reference count, which is likewise undefined behavior.

[mutexguard]: https://github.com/rust-lang/rust/issues/23465#issuecomment-82730326

