```toml
[advisory]
id = "RUSTSEC-2021-0003"
package = "smallvec"
aliases = ["CVE-2021-25900", "GHSA-43w2-9j62-hq99"]
cvss = "CVSS:3.1/AV:N/AC:L/PR:N/UI:N/S:U/C:H/I:H/A:H"
date = "2021-01-08"
url = "https://github.com/servo/rust-smallvec/issues/252"
categories = ["memory-corruption"]
keywords = ["buffer-overflow", "heap-overflow", "unsound"]

[versions]
patched = [">= 0.6.14, < 1.0.0", ">= 1.6.1"]
unaffected = ["< 0.6.3"]

[affected]
functions = { "smallvec::SmallVec::insert_many" = [">= 0.6.3, < 0.6.14", ">= 1.0.0, < 1.6.1"] }
```

# Buffer overflow in SmallVec::insert_many

A bug in the `SmallVec::insert_many` method caused it to allocate a buffer that was smaller than needed.  It then wrote past the end of the buffer, causing a buffer overflow and memory corruption on the heap.

This bug was only triggered if the iterator passed to `insert_many` yielded more items than the lower bound returned from its `size_hint` method.
 
The flaw was corrected in smallvec 0.6.14 and 1.6.1, by ensuring that additional space is always reserved for each item inserted.  The fix also simplified the implementation of `insert_many` to use less unsafe code, so it is easier to verify its correctness.

Thank you to Yechan Bae (@Qwaz) and the Rust group at Georgia Tech’s SSLab for finding and reporting this bug.
