```toml
[advisory]
id = "RUSTSEC-2018-0008"
package = "slice-deque"
aliases = ["CVE-2018-20995", "GHSA-hr3c-6mmp-6m39"]
cvss = "CVSS:3.0/AV:N/AC:L/PR:N/UI:N/S:U/C:H/I:H/A:H"
date = "2018-12-05"
keywords = ["memory-corruption", "rce"]
url = "https://github.com/gnzlbg/slice_deque/issues/57"

[versions]
patched = [">= 0.1.16"]
```

# Bug in SliceDeque::move_head_unchecked allows read of corrupted memory

Affected versions of this crate did not properly update the
head and tail of the deque when inserting and removing elements from the front
if, before insertion or removal, the tail of the deque was in the mirrored
memory region, and if, after insertion or removal, the head of the deque is
exactly at the beginning of the mirrored memory region.

An attacker that controls both element insertion and removal into the deque
could put it in a corrupted state. Once the deque enters such an state, its head
and tail are corrupted, but in bounds of the allocated memory. This can result
in partial reads and writes, reads of uninitialized memory, reads of memory
containing previously dropped objects, etc. An attacker could exploit this to
alter program execution.

The flaw was corrected by properly updating the head and tail of the deque in
this case. 
