```toml
[advisory]
id = "RUSTSEC-2024-0006"
package = "shlex"
date = "2024-01-21"
url = "https://github.com/comex/rust-shlex/security/advisories/GHSA-r7qv-8r2h-pg27"
categories = ["code-execution", "file-disclosure"]
keywords = []
aliases = ["GHSA-r7qv-8r2h-pg27"]

[versions]
patched = [">= 1.3.0"]

[affected.functions]
"shlex::quote" = ["< 1.2.1"]
"shlex::join" = ["< 1.2.1"]
"shlex::bytes::quote" = ["< 1.2.1"]
"shlex::bytes::join" = ["< 1.2.1"]
```

# Multiple issues involving quote API

## Issue 1: Failure to quote characters

Affected versions of this crate allowed the bytes `{` and `\xa0` to appear
unquoted and unescaped in command arguments.

If the output of `quote` or `join` is passed to a shell, then what should be a
single command argument could be interpreted as multiple arguments.

This does not *directly* allow arbitrary command execution (you can't inject a
command substitution or similar).  But depending on the command you're running,
being able to inject multiple arguments where only one is expected could lead
to undesired consequences, potentially including arbitrary command execution.

The flaw was corrected in version 1.2.1 by escaping additional characters.
Updating to 1.3.0 is recommended, but 1.2.1 offers a more minimal fix if
desired.

Workaround: Check for the bytes `{` and `\xa0` in `quote`/`join` input or
output.

(Note: `{` is problematic because it is used for glob expansion.  `\xa0` is
problematic because it's treated as a word separator in [specific
environments][solved-xa0].)

## Issue 2: Dangerous API w.r.t. nul bytes

Version 1.3.0 deprecates the `quote` and `join` APIs in favor of `try_quote`
and `try_join`, which behave the same except that they have `Result` return
type, returning `Err` if the input contains nul bytes.

Strings containing nul bytes generally cannot be used in Unix command arguments
or environment variables, and most shells cannot handle nul bytes even
internally.  If you try to pass one anyway, then the results might be
security-sensitive in uncommon scenarios.  [More details here.][nul-bytes]

Due to the low severity, the behavior of the original `quote` and `join` APIs
has not changed; they continue to allow nuls.

Workaround: Manually check for nul bytes in `quote`/`join` input or output.

## Issue 3: Lack of documentation for interactive shell risks

The `quote` family of functions does not and cannot escape control characters.
With non-interactive shells this is perfectly safe, as control characters have
no special effect.  But if you writing directly to the standard input of an
interactive shell (or through a pty), then control characters [can cause
misbehavior including arbitrary command injection.][control-characters]

This is essentially unfixable, and has not been patched.  But as of version
1.3.0, documentation has been added.

Future versions of `shlex` may add API variants that avoid the issue at the
cost of reduced portability.

[solved-xa0]: https://docs.rs/shlex/latest/shlex/quoting_warning/index.html#solved-xa0
[nul-bytes]: https://docs.rs/shlex/latest/shlex/quoting_warning/index.html#nul-bytes
[control-characters]: https://docs.rs/shlex/latest/shlex/quoting_warning/index.html#control-characters-interactive-contexts-only
