```toml
[advisory]
id = "RUSTSEC-2022-0070"
package = "secp256k1"
date = "2022-11-30"

url = "https://github.com/rust-bitcoin/rust-secp256k1/issues/543"
references = ["https://github.com/rust-bitcoin/rust-secp256k1/pull/548"]
informational = "unsound"
categories = ["memory-corruption"]
keywords = ["use-after-free", "unsound-api", "invalid-free"]
aliases = ["GHSA-969w-q74q-9j8v"]

[affected]
functions = { "secp256k1::Secp256k1::preallocated_gen_new" = ["< 0.22.2", ">= 0.23.0, < 0.23.5", ">= 0.24.0, < 0.24.2"] }

[versions]
patched = [">= 0.22.2, < 0.23.0", ">= 0.23.5, < 0.24.0", ">= 0.24.2"]

unaffected = ["< 0.14.0"]
```

# Unsound API in `secp256k1` allows use-after-free and invalid deallocation from safe code

Because of incorrect bounds on method `Secp256k1::preallocated_gen_new` it was possible to cause use-after-free from safe consumer code. It was also possible to "free" memory not allocated by the appropriate allocator.

The method takes a place for storing the context as a mutable reference and returns context containing that reference. Because the code internally uses `unsafe` and the bounds were incorrect it was possible to create a context that outlived the passed reference (e.g. `'static`). Because the context can alternatively carry heap-allocated pointer freed on drop it was possible to "deallocate" a pointer that wasn't returned from appropriate allocator. The code decides whether to free the memory based on type parameter but because of missing bound it was possible to construct the context with invalid parameter.

You are unaffected if you either

* don't call `Secp256k1::preallocated_gen_new`
* manually checked that your usage of the method is sound
* upgraded to the patched version of `secp256k1` (recommended)

The patched version uses correct bounds which means it is API-breaking. This effectively means adopting the policy of Rust lang itself allowing API-breaking changes to fix soundness bugs. Note however that valid straightforward usage of the code will continue to compile. Only unsound code or code that propagates the bound in custom generics will fail to compile. If the code is sound fixing the bounds should be sufficient to make the code compile.

See the [GitHub issue](https://github.com/rust-bitcoin/rust-secp256k1/issues/543) for example "exploit" code and further discussion.
