```toml
[advisory]
id = "RUSTSEC-2024-0336"
package = "rustls"
date = "2024-04-19"
url = "https://github.com/rustls/rustls/security/advisories/GHSA-6g7w-8wpp-frhj"
categories = ["denial-of-service"]
aliases = ["CVE-2024-32650", "GHSA-6g7w-8wpp-frhj"]
cvss = "CVSS:3.1/AV:N/AC:L/PR:N/UI:N/S:U/C:N/I:N/A:H"

[versions]
patched = [">= 0.23.5", ">= 0.22.4, < 0.23.0", ">= 0.21.11, < 0.22.0"]

[affected]
functions = { "rustls::ConnectionCommon::complete_io" = ["<= 0.23.4", "<= 0.22.3", "<= 0.21.10", "0.20"] }
```

# `rustls::ConnectionCommon::complete_io` could fall into an infinite loop based on network input

If a `close_notify` alert is received during a handshake, `complete_io`
does not terminate.

Callers which do not call `complete_io` are not affected.

`rustls-tokio` and `rustls-ffi` do not call `complete_io`
and are not affected.

`rustls::Stream` and `rustls::StreamOwned` types use
`complete_io` and are affected.
