```toml
[advisory]
id = "RUSTSEC-2022-0046"
package = "rocksdb"
date = "2022-05-11"
url = "https://github.com/rust-rocksdb/rust-rocksdb/pull/616"
categories = ["memory-corruption"]
keywords = ["out-of-bounds read"]
aliases = ["GHSA-xpp3-xrff-w6rh"]

[versions]
patched = [">= 0.19.0"]

[affected]
functions = { "rocksdb::DBWithThreadMode::open_cf_descriptors_with_ttl" = ["< 0.19.0"] }
```

# Out-of-bounds read when opening multiple column families with TTL

Affected versions of this crate called the RocksDB C API
`rocksdb_open_column_families_with_ttl()` with a pointer to a single integer
TTL value, but one TTL value for each column family is expected.

This is only relevant when using
`rocksdb::DBWithThreadMode::open_cf_descriptors_with_ttl()` with multiple
column families.

This bug has been fixed in v0.19.0.
