```toml
[advisory]
id = "RUSTSEC-2020-0028"
package = "rocket"
aliases = ["CVE-2020-35882", "GHSA-8q2v-67v7-6vc6"]
cvss = "CVSS:3.1/AV:N/AC:H/PR:N/UI:N/S:U/C:H/I:H/A:H"
date = "2020-05-27"
informational = "unsound"
url = "https://github.com/SergioBenitez/Rocket/issues/1312"

[affected.functions]
"rocket::local::LocalRequest::clone" = ["< 0.4.5, >= 0.4.0"]

[versions]
patched = [">= 0.4.5"]
unaffected = ["< 0.4.0"]
```

# `LocalRequest::clone` creates multiple mutable references to the same object

The affected version of `rocket` contains a `Clone` trait implementation of
`LocalRequest` that reuses the pointer to inner `Request` object.
This causes data race in rare combinations of APIs if the original and the
cloned objects are modified at the same time.
