```toml
[advisory]
id = "RUSTSEC-2021-0054"
package = "rkyv"
date = "2021-04-28"
url = "https://github.com/djkoloski/rkyv/issues/113"
categories = ["memory-exposure"]
keywords = ["uninitialized", "memory", "information", "leak"]
aliases = ["CVE-2021-31919", "GHSA-w5cr-frph-hw7f"]
cvss = "CVSS:3.1/AV:N/AC:L/PR:N/UI:N/S:U/C:H/I:N/A:N"

[versions]
patched = [">= 0.6.0"]

[affected]
functions = { "rkyv::Archive::resolve" = ["< 0.6.0"] }
```

# Archives may contain uninitialized memory

`rkyv` is a serialization framework that writes struct-compatible memory to be stored or
transmitted. During serialization, struct padding bytes and unused enum bytes may not be
initialized. These bytes may be written to disk or sent over unsecured channels.
