```toml
[advisory]
categories = ["memory-corruption", "memory-exposure"]
date = "2020-05-11"
id = "RUSTSEC-2020-0021"
package = "rio"
aliases = ["CVE-2020-35876", "GHSA-8rc5-mr4f-m243"]
cvss = "CVSS:3.1/AV:N/AC:L/PR:N/UI:N/S:U/C:H/I:H/A:H"
url = "https://github.com/spacejam/rio/issues/11"

[versions]
patched = []
```

# rio allows a use-after-free buffer access when a future is leaked

When a `rio::Completion` is leaked, its drop code will not run. The drop code
is responsible for waiting until the kernel completes the I/O operation into, or
out of, the buffer borrowed by `rio::Completion`. Leaking the struct will allow
one to access and/or drop the buffer, which can lead to a use-after-free,
data races or leaking secrets.

Upstream is not interested in fixing the issue.
