```toml
[advisory]
id = "RUSTSEC-2019-0018"
package = "renderdoc"
aliases = ["CVE-2019-16142", "GHSA-vhfr-v4w9-45v8"]
cvss = "CVSS:3.1/AV:N/AC:L/PR:N/UI:N/S:U/C:H/I:H/A:H"
date = "2019-09-02"
keywords = ["undefined_behavior"]
url = "https://github.com/ebkalderon/renderdoc-rs/pull/32"

[affected.functions]
"renderdoc::api::RenderDocV110::trigger_multi_frame_capture" = ["< 0.5.0"]
"renderdoc::api::RenderDocV120::set_capture_file_comments" = ["< 0.5.0"]

[versions]
patched = [">= 0.5.0"]
```

# Internally mutating methods take immutable ref self

Affected versions of this crate exposed several methods which took `self` by
immutable reference, despite the requesting the RenderDoc API to set a mutable
value internally.

This is technically unsound and calling these methods from multiple threads
without synchronization could lead to unexpected and unpredictable behavior.

The flaw was corrected in release 0.5.0.
