```toml
[advisory]
id = "RUSTSEC-2022-0013"
package = "regex"
date = "2022-03-08"
url = "https://groups.google.com/g/rustlang-security-announcements/c/NcNNL1Jq7Yw"
categories = ["denial-of-service"]
aliases = ["CVE-2022-24713", "GHSA-m5pq-gvj9-9vr8"]
cvss = "CVSS:3.1/AV:N/AC:L/PR:N/UI:N/S:U/C:N/I:N/A:H"

[versions]
patched = [">= 1.5.5"]
```

# Regexes with large repetitions on empty sub-expressions take a very long time to parse

The Rust Security Response WG was notified that the `regex` crate did not
properly limit the complexity of the regular expressions (regex) it parses. An
attacker could use this security issue to perform a denial of service, by
sending a specially crafted regex to a service accepting untrusted regexes. No
known vulnerability is present when parsing untrusted input with trusted
regexes.

This issue has been assigned CVE-2022-24713. The severity of this vulnerability
is "high" when the `regex` crate is used to parse untrusted regexes. Other uses
of the `regex` crate are not affected by this vulnerability.

## Overview

The `regex` crate features built-in mitigations to prevent denial of service
attacks caused by untrusted regexes, or untrusted input matched by trusted
regexes. Those (tunable) mitigations already provide sane defaults to prevent
attacks. This guarantee is documented and it's considered part of the crate's
API.

Unfortunately a bug was discovered in the mitigations designed to prevent
untrusted regexes to take an arbitrary amount of time during parsing, and it's
possible to craft regexes that bypass such mitigations. This makes it possible
to perform denial of service attacks by sending specially crafted regexes to
services accepting user-controlled, untrusted regexes.

## Affected versions

All versions of the `regex` crate before or equal to 1.5.4 are affected by this
issue. The fix is include starting from  `regex` 1.5.5.

## Mitigations

We recommend everyone accepting user-controlled regexes to upgrade immediately
to the latest version of the `regex` crate.

Unfortunately there is no fixed set of problematic regexes, as there are
practically infinite regexes that could be crafted to exploit this
vulnerability. Because of this, we do not recommend denying known problematic
regexes.

## Acknowledgements

We want to thank Addison Crump for responsibly disclosing this to us according
to the [Rust security policy][1], and for helping review the fix.

We also want to thank Andrew Gallant for developing the fix, and Pietro Albini
for coordinating the disclosure and writing this advisory.

[1]: https://www.rust-lang.org/policies/security
