```toml
[advisory]
id = "RUSTSEC-2021-0089"
package = "raw-cpuid"
date = "2021-01-20"
url = "https://github.com/gz/rust-cpuid/issues/43"
categories = ["memory-corruption", "denial-of-service"]
aliases = ["CVE-2021-45687", "GHSA-jf5h-cf95-w759", "GHSA-w428-f65r-h4q2"]

[versions]
patched = [">= 9.1.1"]
unaffected = ["<= 3.1.0"]
```

# Optional `Deserialize` implementations lacking validation

When activating the non-default feature `serialize`, most structs implement
`serde::Deserialize` without sufficient validation. This allows breaking
invariants in safe code, leading to:

* Undefined behavior in `as_string()` methods (which use
  `std::str::from_utf8_unchecked()` internally).
* Panics due to failed assertions.

See https://github.com/gz/rust-cpuid/issues/43.
