```toml
[advisory]
id = "RUSTSEC-2024-0373"
package = "quinn-proto"
date = "2024-09-02"
url = "https://github.com/quinn-rs/quinn"
categories = ["denial-of-service"]
keywords = ["panic"]
aliases = ["GHSA-vr26-jcq5-fjj8", "CVE-2024-45311"]
cvss = "CVSS:3.1/AV:N/AC:L/PR:N/UI:N/S:U/C:N/I:N/A:H"

[versions]
patched = [">= 0.11.7"]
unaffected = ["< 0.11.0"]
```

# `Endpoint::retry()` calls can lead to panicking

In 0.11.0, we overhauled the server-side `Endpoint` implementation to enable
more careful handling of incoming connection attempts. However, some of the
code paths that cleaned up state after connection attempts were processed
confused the initial destination connection ID with the destination connection
ID of a substantial package. This resulted in the internal `Endpoint` state
becoming inconsistent, which could then lead to a panic.

https://github.com/quinn-rs/quinn/commit/e01609ccd8738bd438d86fa7185a0f85598cb58f

Thanks to [@finbear](https://github.com/finnbear) for reporting and investingating,
and to [@BiagoFesta](https://github.com/BiagoFesta) for coordinating.
