```toml
[advisory]
id = "RUSTSEC-2022-0007"
package = "qcell"
date = "2022-01-24"
url = "https://github.com/uazu/qcell/issues/20"
informational = "unsound"
keywords = ["unsound"]
aliases = ["GHSA-9c9f-7x9p-4wqp"]

[versions]
patched = [">= 0.4.3"]
```

# A malicious coder can get unsound access to TCell or TLCell memory

This is impossible to do by accident, but by carefully constructing
marker types to be covariant, a malicious coder can cheat the
singleton check in `TCellOwner` and `TLCellOwner`, giving unsound
access to cell memory.  This could take the form of getting two
mutable references to the same memory, or a mutable reference and an
immutable reference.

The fix is for the crate to internally force the marker type to be
invariant.  This blocks the conversion between covariant types which
Rust normally allows.
