```toml
[advisory]
id = "RUSTSEC-2019-0003"
package = "protobuf"
aliases = ["CVE-2019-15544", "GHSA-mh6h-f25p-98f8"]
cvss = "CVSS:3.1/AV:N/AC:L/PR:N/UI:N/S:U/C:N/I:N/A:H"
categories = ["denial-of-service"]
date = "2019-06-08"
keywords = ["oom", "panic"]
url = "https://github.com/stepancheg/rust-protobuf/issues/411"

[affected.functions]
"protobuf::stream::read_raw_bytes_into" = ["< 2.6.0"]

[versions]
patched = ["^1.7.5", ">= 2.6.0"]
```

# Out of Memory in stream::read_raw_bytes_into()

Affected versions of this crate called Vec::reserve() on user-supplied input.

This allows an attacker to cause an Out of Memory condition while calling the
vulnerable method on untrusted data.
