```toml
[advisory]
id = "RUSTSEC-2020-0167"
package = "pnet_packet"
date = "2020-06-19"
url = "https://github.com/libpnet/libpnet/issues/449"
categories = ["memory-corruption"]
cvss = "CVSS:3.0/AV:L/AC:L/PR:H/UI:N/S:U/C:N/I:H/A:H"
aliases = ["GHSA-cf4g-fcf8-3cr9"]

[versions]
patched = [">= 0.27.2"]
```

# `pnet_packet` buffer overrun in `set_payload` setters

As indicated by this [issue](https://github.com/libpnet/libpnet/issues/449#issuecomment-663355987), a buffer overrun is possible in the `set_payload` setter of the various mutable "Packet" struct setters. The offending `set_payload` functions were defined within the struct `impl` blocks in earlier versions of the package, and later by the `packet` macro.

Fixed in the `packet` macro by [this](https://github.com/libpnet/libpnet/pull/455) PR.
