```toml
[advisory]
id = "RUSTSEC-2023-0022"
package = "openssl"
date = "2023-03-24"
url = "https://github.com/sfackler/rust-openssl/pull/1854"
categories = ["thread-safety"]
aliases = ["GHSA-3gxf-9r58-2ghg"]

[affected]
functions = { "openssl::x509::X509NameBuilder::build" = ["< 0.10.48, >=0.9.7"] }

[versions]
patched = [">= 0.10.48"]
```

# `openssl` `X509NameBuilder::build` returned object is not thread safe

OpenSSL has a `modified` bit that it can set on on `X509_NAME` objects. If this
bit is set then the object is not thread-safe even when it appears the code is
not modifying the value.

Thanks to David Benjamin (Google) for reporting this issue.
