```toml
[advisory]
id = "RUSTSEC-2023-0012"
package = "openssl-src"
aliases = ["CVE-2023-0217", "GHSA-vxrh-cpg7-8vjr"]
categories = ["denial-of-service"]
date = "2023-02-07"
url = "https://www.openssl.org/news/secadv/20230207.txt"
[versions]
patched = [">= 300.0.12"]
unaffected = ["< 300.0.0"]
```

# `NULL` dereference validating DSA public key

An invalid pointer dereference on read can be triggered when an
application tries to check a malformed DSA public key by the
`EVP_PKEY_public_check()` function. This will most likely lead
to an application crash. This function can be called on public
keys supplied from untrusted sources which could allow an attacker
to cause a denial of service attack.

The TLS implementation in OpenSSL does not call this function
but applications might call the function if there are additional
security requirements imposed by standards such as FIPS 140-3.
