```toml
[advisory]
id = "RUSTSEC-2023-0010"
package = "openssl-src"
aliases = ["CVE-2022-4450", "GHSA-v5w6-wcm8-jm4q"]
categories = ["denial-of-service"]
date = "2023-02-07"
url = "https://www.openssl.org/news/secadv/20230207.txt"
[versions]
patched = [">= 111.25, < 300.0", ">= 300.0.12"]
```

# Double free after calling `PEM_read_bio_ex`

The function `PEM_read_bio_ex()` reads a PEM file from a BIO and parses and
decodes the "name" (e.g. "CERTIFICATE"), any header data and the payload data.
If the function succeeds then the "name_out", "header" and "data" arguments are
populated with pointers to buffers containing the relevant decoded data. The
caller is responsible for freeing those buffers. It is possible to construct a
PEM file that results in 0 bytes of payload data. In this case `PEM_read_bio_ex()`
will return a failure code but will populate the header argument with a pointer
to a buffer that has already been freed. If the caller also frees this buffer
then a double free will occur. This will most likely lead to a crash. This
could be exploited by an attacker who has the ability to supply malicious PEM
files for parsing to achieve a denial of service attack.

The functions `PEM_read_bio()` and `PEM_read()` are simple wrappers around
`PEM_read_bio_ex()` and therefore these functions are also directly affected.

These functions are also called indirectly by a number of other OpenSSL
functions including `PEM_X509_INFO_read_bio_ex()` and
`SSL_CTX_use_serverinfo_file()` which are also vulnerable. Some OpenSSL internal
uses of these functions are not vulnerable because the caller does not free the
header argument if `PEM_read_bio_ex()` returns a failure code. These locations
include the `PEM_read_bio_TYPE()` functions as well as the decoders introduced in
OpenSSL 3.0.
