```toml
[advisory]
id = "RUSTSEC-2023-0006"
package = "openssl-src"
aliases = ["CVE-2023-0286", "GHSA-x4qr-2fvf-3mr5"]
categories = ["denial-of-service", "memory-exposure"]
date = "2023-02-07"
url = "https://www.openssl.org/news/secadv/20230207.txt"
[versions]
patched = [">= 111.25, < 300.0", ">= 300.0.12"]
```

# X.400 address type confusion in X.509 `GeneralName`

There is a type confusion vulnerability relating to X.400 address processing
inside an X.509 `GeneralName`. X.400 addresses were parsed as an `ASN1_STRING` but
the public structure definition for `GENERAL_NAME` incorrectly specified the type
of the `x400Address` field as `ASN1_TYPE`. This field is subsequently interpreted by
the OpenSSL function `GENERAL_NAME_cmp` as an `ASN1_TYPE` rather than an
`ASN1_STRING`.

When CRL checking is enabled (i.e. the application sets the
`X509_V_FLAG_CRL_CHECK` flag), this vulnerability may allow an attacker to pass
arbitrary pointers to a `memcmp` call, enabling them to read memory contents or
enact a denial of service. In most cases, the attack requires the attacker to
provide both the certificate chain and CRL, neither of which need to have a
valid signature. If the attacker only controls one of these inputs, the other
input must already contain an X.400 address as a CRL distribution point, which
is uncommon. As such, this vulnerability is most likely to only affect
applications which have implemented their own functionality for retrieving CRLs
over a network.
