```toml
[advisory]
id = "RUSTSEC-2022-0065"
package = "openssl-src"
aliases = ["CVE-2022-3786", "GHSA-h8jm-2x53-xhp5"]
categories = ["denial-of-service"]
date = "2022-11-01"
url = "https://www.openssl.org/news/secadv/20221101.txt"
[versions]
patched = [">= 300.0.11"]
unaffected = ["< 300.0.0"]
```

# X.509 Email Address Variable Length Buffer Overflow

A buffer overrun can be triggered in X.509 certificate verification,
specifically in name constraint checking. Note that this occurs after
certificate chain signature verification and requires either a CA to
have signed a malicious certificate or for an application to continue
certificate verification despite failure to construct a path to a trusted
issuer. An attacker can craft a malicious email address in a certificate
to overflow an arbitrary number of bytes containing the `.` character
(decimal 46) on the stack. This buffer overflow could result in a crash
(causing a denial of service).

In a TLS client, this can be triggered by connecting to a malicious
server. In a TLS server, this can be triggered if the server requests
client authentication and a malicious client connects.
