```toml
[advisory]
id = "RUSTSEC-2022-0064"
package = "openssl-src"
aliases = ["CVE-2022-3602", "GHSA-8rwr-x37p-mx23"]
categories = ["denial-of-service", "code-execution"]
date = "2022-11-01"
url = "https://www.openssl.org/news/secadv/20221101.txt"

[versions]
patched = [">= 300.0.11"]
unaffected = ["< 300.0.0"]
```

# X.509 Email Address 4-byte Buffer Overflow

A buffer overrun can be triggered in X.509 certificate verification,
specifically in name constraint checking. Note that this occurs
after certificate chain signature verification and requires either a
CA to have signed the malicious certificate or for the application to
continue certificate verification despite failure to construct a path
to a trusted issuer. An attacker can craft a malicious email address
to overflow four attacker-controlled bytes on the stack. This buffer
overflow could result in a crash (causing a denial of service) or
potentially remote code execution.

Many platforms implement stack overflow protections which would mitigate
against the risk of remote code execution. The risk may be further
mitigated based on stack layout for any given platform/compiler.

Pre-announcements of CVE-2022-3602 described this issue as CRITICAL.
Further analysis based on some of the mitigating factors described above
have led this to be downgraded to HIGH. Users are still encouraged to
upgrade to a new version as soon as possible.

In a TLS client, this can be triggered by connecting to a malicious
server. In a TLS server, this can be triggered if the server requests
client authentication and a malicious client connects.
