```toml
[advisory]
id = "RUSTSEC-2023-0032"
package = "ntru"
date = "2023-03-22"
url = "https://github.com/FrinkGlobal/ntru-rs/issues/8"
categories = ["memory-corruption"]
keywords = ["ffi", "buffer overflow"]
informational = "unsound"
aliases = ["GHSA-fq33-vmhv-48xh"]

[versions]
patched = []

[affected.functions]
"ntru::types::PrivateKey::export" = [">= 0.4.3"]
"ntru::types::PublicKey::export" = [">= 0.4.3"]
```

# Unsound FFI: Wrong API usage causes write past allocated area

The following usage causes undefined behavior.
```rust
let kp: ntru::types::KeyPair = …;
kp.get_public().export(Default::default())
```

When compiled with debug assertions, the code above will trigger a `attempt to subtract with overflow` panic before UB occurs.
Other mistakes (e.g. using `EncParams` from a different key) may always trigger UB.

Likely, older versions of this crate are also affected, but have not been tested.
