```toml
[advisory]
id = "RUSTSEC-2020-0141"
package = "noise_search"
date = "2020-12-10"
url = "https://github.com/pipedown/noise/issues/72"
categories = ["memory-corruption", "thread-safety"]
aliases = ["CVE-2020-36461", "GHSA-wxjf-9f4g-3v44"]
cvss = "CVSS:3.1/AV:N/AC:H/PR:N/UI:N/S:U/C:H/I:H/A:H"

[versions]
patched = []
```

# MvccRwLock allows data races & aliasing violations

Affected versions of this crate unconditionally implement Send/Sync for `MvccRwLock`.
This can lead to data races when types that are either `!Send` or `!Sync` (e.g. `Rc<T>`, `Arc<Cell<_>>`) are contained inside `MvccRwLock` and sent across thread boundaries. The data races can potentially lead to memory corruption (as demonstrated in the PoC from the original report issue).

Also, safe APIs of `MvccRwLock` allow aliasing violations by allowing `&T` and `LockResult<MutexGuard<Box<T>>>` to co-exist in conflicting lifetime regions. The APIs of `MvccRwLock` should either be marked as `unsafe` or `MbccRwLock` should be changed to private or pub(crate).
