```toml
[advisory]
id = "RUSTSEC-2024-0430"
package = "magic-crypt"
date = "2024-12-28"
url = "https://github.com/magiclen/rust-magiccrypt/issues/17"
categories = ["crypto-failure"]
keywords = ["crypto", "unsound"]

[versions]
patched = []
```

# Use of insecure cryptographic algorithms

This crate uses a number of cryptographic algorithms that are no longer
considered secure and it uses them in ways that do not guarantee the integrity
of the encrypted data.

`MagicCrypt64` uses the insecure DES block cipher in CBC mode without
authentication. This allows for practical brute force and padding oracle
attacks and does not protect the integrity of the encrypted data. Key and IV
are generated from user input using CRC64, which is not at all a key derivation
function.

`MagicCrypt64`, `MagicCrypt128`, `MagicCrypt192`, and `MagicCrypt256` are all
vulnerable to padding-oracle attacks. None of them protect the integrity of the
ciphertext. Furthermore, none use password-based key derivation functions, even
though the key is intended to be generated from a password.

Each of the implementations are unsound in that they use uninitialized memory
without `MaybeUninit` or equivalent structures.

For more information, visit the [issue](https://github.com/magiclen/rust-magiccrypt/issues/17).
