```toml
[advisory]
id = "RUSTSEC-2024-0407"
package = "linkme"
date = "2024-03-05"
url = "https://github.com/dtolnay/linkme/issues/82"
informational = "unsound"

[versions]
patched = [">= 0.3.24"]
```

# Fails to ensure slice elements match the slice's declared type

Affected versions allow populating a DistributedSlice of T with elements of an
arbitrary other type that coerces to T. For example, elements of type `&&str`
could end up in a slice of type `[&str]`, since `&&str` coerces to `&str` via a
deref coercion.

The flaw was corrected by implementing typechecking for distributed slice
elements in such a way that coercion no longer occurs. The element's type must
be a subtype of the slice's declared element type.
