```toml
[advisory]
id = "RUSTSEC-2019-0027"
package = "libsecp256k1"
aliases = ["CVE-2019-25003", "GHSA-hrjm-c879-pp86"]
cvss = "CVSS:3.1/AV:N/AC:L/PR:N/UI:N/S:U/C:H/I:N/A:N"
categories = ["crypto-failure"]
date = "2019-10-14"
keywords = ["crypto", "sidechannel"]

[affected.functions]
"libsecp256k1::Scalar::check_overflow" = ["< 0.3.1"]

[versions]
patched = [">= 0.3.1"]
```

# Flaw in Scalar::check_overflow allows side-channel timing attack

Versions of `libsecp256k1` prior to `0.3.1` did not execute
Scalar::check_overflow in constant time.

This allows an attacker to potentially leak information via a timing attack.

The flaw was corrected by modifying Scalar::check_overflow to execute in
constant time.
