```toml
[advisory]
id = "RUSTSEC-2018-0020"
package = "libpulse-binding"
date = "2018-12-22"
url = "https://github.com/advisories/GHSA-6gvc-4jvj-pwq4"
categories = ["memory-corruption"]
aliases = ["CVE-2018-25001", "GHSA-6gvc-4jvj-pwq4", "GHSA-f56g-chqp-22m9"]
cvss = "CVSS:3.1/AV:N/AC:L/PR:L/UI:N/S:U/C:N/I:H/A:N"

[versions]
patched = [">= 2.5.0"]
unaffected = ["< 1.0.5"]
```

# Possible use-after-free with `proplist::Iterator`

Affected versions contained a possible use-after-free issue with property list iteration
due to a lack of a lifetime constraint tying the lifetime of a `proplist::Iterator` to the
`Proplist` object for which it was created. This made it possible for users, without
experiencing a compiler error/warning, to destroy the `Proplist` object before the iterator,
thus destroying the underlying C object the iterator works upon, before the iterator may be
finished with it.

This impacts all versions of the crate before `2.5.0` back to `1.0.5`. Before version
`1.0.5` the function that produces the iterator was broken to the point of being useless.
