```toml
[advisory]
id = "RUSTSEC-2023-0048"
package = "intaglio"
date = "2023-07-26"
url = "https://github.com/artichoke/intaglio/pull/236"
references = [
  "https://github.com/artichoke/intaglio/issues/235",
  "https://github.com/artichoke/intaglio/pull/236",
  "https://github.com/artichoke/intaglio/releases/tag/v1.9.0",
]
informational = "unsound"
aliases = ["GHSA-gch5-hwqf-mxhp"]

[affected]
functions = { "intaglio::SymbolTable::intern" = ["< 1.9.0"], "intaglio::bytes::SymbolTable::intern" = ["< 1.9.0"], "intaglio::cstr::SymbolTable::intern" = ["< 1.9.0, >= 1.5.0"], "intaglio::osstr::SymbolTable::intern" = ["< 1.9.0, >= 1.5.0"], "intaglio::path::SymbolTable::intern" = ["< 1.9.0, >= 1.5.0"] }

[versions]
patched = [">= 1.9.0"]
```

# Unsoundness in `intern` methods on `intaglio` symbol interners

Affected versions of this crate have a stacked borrows violation when creating
references to interned contents. All interner types are affected.

The flaw was corrected in version 1.9.0 by reordering move and borrowing
operations and storing interned contents by raw pointer instead of as a `Box`.
