```toml
[advisory]
id = "RUSTSEC-2024-0003"
package = "h2"
date = "2024-01-17"
references = ["https://github.com/Netflix/security-bulletins/blob/master/advisories/third-party/2019-002.md"]
categories = ["denial-of-service"]
keywords = ["http", "http2", "h2"]
related = ["CVE-2019-9514"]
aliases = ["GHSA-8r5v-vm4m-4g25"]

[versions]
patched = ["^0.3.24", ">= 0.4.2"]
```

# Resource exhaustion vulnerability in h2 may lead to Denial of Service (DoS)

An attacker with an HTTP/2 connection to an affected endpoint can send a steady stream of invalid frames to force the
generation of reset frames on the victim endpoint.
By closing their recv window, the attacker could then force these resets to be queued in an unbounded fashion,
resulting in Out Of Memory (OOM) and high CPU usage.

This fix is corrected in [hyperium/h2#737](https://github.com/hyperium/h2/pull/737), which limits the total number of
internal error resets emitted by default before the connection is closed.
