```toml
[advisory]
id = "RUSTSEC-2024-0435"
package = "fyrox-core"
date = "2024-12-19"
url = "https://github.com/FyroxEngine/Fyrox/issues/630"
references = ["https://github.com/FyroxEngine/Fyrox/pull/662"]
categories = []
keywords = ["uninitialized"]
informational = "unsound"

[versions]
patched = [">= 0.36"]

[affected]
functions = {"fyrox_core::transmute_vec_as_bytes" = [">= 0.28.1, <= 0.36"]}
```

# Unsound usages of `Vec::from_raw_parts` 

The library provides a public safe API `transmute_vec_as_bytes`, which incorrectly assumes that any generic type `T` could have stable layout, causing to uninitialized memory exposure if the users pass any types with padding bytes as `T` and cast it to `u8` pointer.  

In the [issue](https://github.com/FyroxEngine/Fyrox/issues/630), we develop a PoC to show passing struct type to `transmute_vec_as_bytes` could lead to undefined behavior with `Vec::from_raw_parts`.  

The developers provide a patch by changing trait of `Copy` to `Pod`, which can make sure `T` should be plain data. This was patched in the latest version of [master](https://github.com/FyroxEngine/Fyrox/blob/3f9ad6f9667047dac051b0e97d544e5b38e5ae72/fyrox-core/src/lib.rs#L351-L360) branch, but still not on the latest release (0.28.1).
