```toml
[advisory]
id = "RUSTSEC-2019-0036"
package = "failure"
aliases = ["CVE-2019-25010", "CVE-2020-25575", "GHSA-jq66-xh47-j9f3", "GHSA-r98r-j25q-rmpr"]
cvss = "CVSS:3.1/AV:N/AC:L/PR:N/UI:N/S:U/C:H/I:H/A:H"
date = "2019-11-13"
informational = "unsound"
keywords = ["unsound"]
url = "https://github.com/rust-lang-nursery/failure/issues/336"

[affected.functions]
"failure::Fail::__private_get_type_id__" = [">= 0.1.0"]

[versions]
patched = []
```

# Type confusion if __private_get_type_id__ is overridden

Safe Rust code can implement malfunctioning `__private_get_type_id__` and cause
type confusion when downcasting, which is an undefined behavior.

Users who derive `Fail` trait are not affected.
