```toml
[advisory]
id = "RUSTSEC-2021-0039"
package = "endian_trait"
aliases = ["CVE-2021-29929", "GHSA-vpw8-43wm-rxw5"]
cvss = "CVSS:3.1/AV:N/AC:L/PR:N/UI:N/S:U/C:N/I:N/A:H"
date = "2021-01-04"
url = "https://gitlab.com/myrrlyn/endian_trait/-/issues/1"
categories = ["memory-corruption"]

[versions]
patched = []
```

# panic in user-provided `Endian` impl triggers double drop of T

Affected versions of the crate does not guard against panic from user-provided impl of `Endian` trait, which is a safe trait that users can implement.
If a user-provided implementation of the `Endian` trait panics, double-drop is triggered due to the duplicated ownership of `T` created by `ptr::read()`.

Double-drop (or double free) can cause memory corruption in the heap.
