```toml
[advisory]
id = "RUSTSEC-2018-0009"
package = "crossbeam"
aliases = ["CVE-2018-20996", "GHSA-c3cw-c387-pj65"]
cvss = "CVSS:3.0/AV:N/AC:L/PR:N/UI:N/S:U/C:H/I:H/A:H"
date = "2018-12-09"
keywords = ["concurrency", "memory-management", "memory-corruption"]
url = "https://github.com/crossbeam-rs/crossbeam-epoch/issues/82"

[versions]
patched = [">= 0.4.1"]
unaffected = ["< 0.4.0"]
```

# MsQueue and SegQueue suffer from double-free

Even if an element is popped from a queue, crossbeam would run its
destructor inside the epoch-based garbage collector. This is a source
of double frees.

The flaw was corrected by wrapping elements inside queues in a
`ManuallyDrop`.

Thanks to @c0gent for reporting the issue.
