```toml
[advisory]
id = "RUSTSEC-2020-0125"
package = "convec"
date = "2020-11-24"
url = "https://github.com/krl/convec/issues/2"
categories = ["memory-corruption", "thread-safety"]
aliases = ["CVE-2020-36445", "GHSA-rpxm-vmr7-5f5f"]
cvss = "CVSS:3.1/AV:N/AC:H/PR:N/UI:N/S:U/C:H/I:H/A:H"

[versions]
patched = []
```

# convec::ConVec<T> unconditionally implements Send/Sync

Affected versions of this crate unconditionally implement Send/Sync for `ConVec<T>`.
This allows users to insert `T` that is not Send or not Sync.

This allows users to create data races by using non-Send types like `Arc<Cell<_>>` or `Rc<_>` as `T` in `ConVec<T>`. It is also possible to create data races by using types like `Cell<_>` or `RefCell<_>` as `T` (types that are `Send` but not `Sync`).
Such data races can lead to memory corruption.
