```toml
[advisory]
id = "RUSTSEC-2023-0020"
package = "const-cstr"
date = "2023-03-12"
url = "https://github.com/abonander/const-cstr"
informational = "unsound"

[versions]
patched = []
```

# const-cstr is Unmaintained

Last release was about five years ago.

The maintainer(s) have been unreachable to respond to any issues that may or may not include security issues.

The repository is now archived and there is no security policy in place to contact the maintainer(s) otherwise.

No direct fork exist.

# const-cstr is Unsound

The crate violates the safety contract of [ffi::CStr::from_bytes_with_nul_unchecked](https://doc.rust-lang.org/std/ffi/struct.CStr.html#method.from_bytes_with_nul_unchecked) used in `ConstCStr::as_cstr`

No interior nul bytes checking is done either by the constructor or the canonical macro to create the `ConstCStr`

# const-cstr Panic

Additionally the crate may cause runtime panics if statically compiled and ran with any untrusted data that is not nul-terminated.

This is however unlikely but the the crate should not be used for untrusted data in context where panic may create a DoS vector.

## Possible Alternatives

The below may or may not provide alternative(s)

- [const_str::cstr!](https://docs.rs/const-str/latest/const_str/macro.cstr.html)
- [cstr::cstr!](https://crates.io/crates/cstr)
