```toml
[advisory]
id = "RUSTSEC-2021-0012"
package = "cdr"
aliases = ["CVE-2021-26305", "GHSA-37jj-wp7g-7wj4"]
cvss = "CVSS:3.1/AV:N/AC:L/PR:N/UI:N/S:U/C:H/I:H/A:H"
date = "2021-01-02"
url = "https://github.com/hrektts/cdr-rs/issues/10"
categories = ["memory-exposure"]

[versions]
patched = [">= 0.2.4"]
```

# Reading uninitialized memory can cause UB (`Deserializer::read_vec`)

`Deserializer::read_vec()` created an uninitialized buffer and passes it to a user-provided `Read` implementation (`Deserializer.reader.read_exact()`).

Passing an uninitialized buffer to an arbitrary `Read` implementation is currently defined as undefined behavior in Rust. Official documentation for the `Read` trait explains the following: "It is your responsibility to make sure that buf is initialized before calling read. Calling read with an uninitialized buf (of the kind one obtains via MaybeUninit<T>) is not safe, and can lead to undefined behavior."

The flaw was corrected in commit ce310f7 by zero-initializing the newly allocated buffer before handing it to `Deserializer.reader.read_exact()`.
