```toml
[advisory]
id = "RUSTSEC-2021-0015"
package = "calamine"
aliases = ["CVE-2021-26951", "GHSA-ppqp-78xx-3r38"]
cvss = "CVSS:3.1/AV:N/AC:L/PR:N/UI:N/S:U/C:H/I:H/A:H"
date = "2021-01-06"
url = "https://github.com/tafia/calamine/issues/199"
categories = ["memory-corruption", "memory-exposure"]

[versions]
patched = [">= 0.17.0"]
```

# `Sectors::get` accesses unclaimed/uninitialized memory

Affected versions of this crate arbitrarily calls `Vec::set_len` to increase length of a vector without claiming more memory for the vector. Affected versions of this crate
also calls user-provided `Read` on the uninitialized memory of the vector that was
extended with `Vec::set_len`.

This can overwrite active entities in adjacent heap memory and seems to be a major security issue. Also, calling user-provided `Read` on uninitialized memory is defined as UB in Rust.
