```toml
[advisory]
id = "RUSTSEC-2021-0145"
package = "atty"
date = "2021-07-04"
url = "https://github.com/softprops/atty/issues/50"
references = ["https://github.com/softprops/atty/pull/51", "https://github.com/softprops/atty/issues/57"]
keywords = ["unaligned-read"]
informational = "unsound"
aliases = ["GHSA-g98v-hv3f-hcfr"]

[affected]
os = ["windows"]

[versions]
patched = []
```

# Potential unaligned read

On windows, `atty` dereferences a potentially unaligned pointer.

In practice however, the pointer won't be unaligned unless a custom global allocator is used.

In particular, the `System` allocator on windows uses `HeapAlloc`, which guarantees a large enough alignment.

# atty is Unmaintained

A Pull Request with a fix has been provided over a year ago but the maintainer seems to be unreachable.

Last release of `atty` was almost 3 years ago.

## Possible Alternative(s)

The below list has not been vetted in any way and may or may not contain alternatives;

 - [std::io::IsTerminal](https://doc.rust-lang.org/stable/std/io/trait.IsTerminal.html) - Stable since Rust 1.70.0
 - [is-terminal](https://crates.io/crates/is-terminal) - Standalone crate supporting Rust older than 1.70.0

