```toml
[advisory]
id = "RUSTSEC-2021-0040"
package = "arenavec"
aliases = ["CVE-2021-29930", "CVE-2021-29931", "GHSA-327x-39hh-65wf", "GHSA-955p-rc5h-hg6h"]
cvss = "CVSS:3.1/AV:N/AC:L/PR:N/UI:N/S:U/C:N/I:N/A:H"
date = "2021-01-12"
url = "https://github.com/ibabushkin/arenavec/issues/1"
categories = ["memory-corruption"]

[versions]
patched = []
```

# panic safety: double drop or uninitialized drop of T upon panic

Affected versions of this crate did not guard against potential panics that may happen from user-provided functions `T::default()` and `T::drop()`.

Panic within `T::default()` leads to dropping uninitialized `T`, when it is invoked from `common::Slice::<T, H>::new()`.
Panic within `T::drop()` leads to double drop of `T`, when it is invoked either from `common::SliceVec::<T, H>::resize_with()` or `common::SliceVec::<T, H>::resize()`

Either case causes memory corruption in the heap memory.
