```toml
[advisory]
id = "RUSTSEC-2021-0081"
package = "actix-http"
date = "2021-06-16"
keywords = ["smuggling", "http", "reverse proxy", "request smuggling"]
aliases = ["CVE-2021-38512", "GHSA-8928-2fgm-6x9x"]
cvss = "CVSS:3.1/AV:N/AC:L/PR:N/UI:N/S:U/C:H/I:N/A:N"

[versions]
patched = ["^ 2.2.1", ">= 3.0.0-beta.9"]
```

# Potential request smuggling capabilities due to lack of input validation

Affected versions of this crate did not properly detect invalid requests that could allow HTTP/1 request smuggling (HRS) attacks when running alongside a vulnerable front-end proxy server. This can result in leaked internal and/or user data, including credentials, when the front-end proxy is also vulnerable.

Popular front-end proxies and load balancers already mitigate HRS attacks so it is recommended that they are also kept up to date; check your specific set up. You should upgrade even if the front-end proxy receives exclusively HTTP/2 traffic and connects to the back-end using HTTP/1; several downgrade attacks are known that can also expose HRS vulnerabilities.
