/*
 * Decompiled with CFR 0.152.
 */
package fr.jayasoft.ivy.parser;

import fr.jayasoft.ivy.DefaultDependencyDescriptor;
import fr.jayasoft.ivy.DefaultModuleDescriptor;
import fr.jayasoft.ivy.DependencyDescriptor;
import fr.jayasoft.ivy.Ivy;
import fr.jayasoft.ivy.ModuleDescriptor;
import fr.jayasoft.ivy.ModuleRevisionId;
import fr.jayasoft.ivy.parser.ModuleDescriptorParser;
import fr.jayasoft.ivy.repository.Resource;
import fr.jayasoft.ivy.repository.url.URLResource;
import fr.jayasoft.ivy.util.Message;
import java.io.IOException;
import java.net.URL;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public abstract class AbstractModuleDescriptorParser
implements ModuleDescriptorParser {
    public ModuleDescriptor parseDescriptor(Ivy ivy, URL descriptorURL, boolean validate) throws ParseException, IOException {
        return this.parseDescriptor(ivy, descriptorURL, new URLResource(descriptorURL), validate);
    }

    protected static abstract class AbstractParser
    extends DefaultHandler {
        private static final String DEFAULT_CONF_MAPPING = "*->*";
        private String _defaultConf;
        private String _defaultConfMapping;
        private DefaultDependencyDescriptor _defaultConfMappingDescriptor;
        private Resource _res;
        private List _errors = new ArrayList();
        protected DefaultModuleDescriptor _md;

        protected AbstractParser() {
        }

        protected void checkErrors() throws ParseException {
            if (!this._errors.isEmpty()) {
                throw new ParseException(this._errors.toString(), 0);
            }
        }

        protected void setResource(Resource res) {
            this._md = new DefaultModuleDescriptor();
            this._res = res;
            this._md.setLastModified(this.getLastModified());
        }

        protected Resource getResource() {
            return this._res;
        }

        protected String getDefaultConfMapping() {
            return this._defaultConfMapping;
        }

        protected void setDefaultConfMapping(String defaultConf) {
            this._defaultConfMapping = defaultConf;
        }

        protected void parseDepsConfs(String confs, DefaultDependencyDescriptor dd) {
            this.parseDepsConfs(confs, dd, this._defaultConfMapping != null);
        }

        protected void parseDepsConfs(String confs, DefaultDependencyDescriptor dd, boolean useDefaultMappingToGuessRightOperande) {
            String[] conf = confs.split(";");
            for (int i = 0; i < conf.length; ++i) {
                int k;
                String[] modConfs;
                String[] ops = conf[i].split("->");
                if (ops.length == 1) {
                    int j;
                    modConfs = ops[0].split(",");
                    if (!useDefaultMappingToGuessRightOperande) {
                        for (j = 0; j < modConfs.length; ++j) {
                            dd.addDependencyConfiguration(modConfs[j].trim(), modConfs[j].trim());
                        }
                        continue;
                    }
                    for (j = 0; j < modConfs.length; ++j) {
                        String[] depConfs = this.getDefaultConfMappingDescriptor().getDependencyConfigurations(modConfs[j]);
                        for (k = 0; k < depConfs.length; ++k) {
                            dd.addDependencyConfiguration(modConfs[j].trim(), depConfs[k].trim());
                        }
                    }
                    continue;
                }
                if (ops.length == 2) {
                    modConfs = ops[0].split(",");
                    String[] depConfs = ops[1].split(",");
                    for (int j = 0; j < modConfs.length; ++j) {
                        for (k = 0; k < depConfs.length; ++k) {
                            dd.addDependencyConfiguration(modConfs[j].trim(), depConfs[k].trim());
                        }
                    }
                    continue;
                }
                this.addError("invalid conf " + conf[i] + " for " + dd.getDependencyRevisionId());
            }
        }

        protected DependencyDescriptor getDefaultConfMappingDescriptor() {
            if (this._defaultConfMappingDescriptor == null) {
                this._defaultConfMappingDescriptor = new DefaultDependencyDescriptor(ModuleRevisionId.newInstance("", "", ""), false);
                this.parseDepsConfs(this._defaultConfMapping, this._defaultConfMappingDescriptor, false);
            }
            return this._defaultConfMappingDescriptor;
        }

        protected void addError(String msg) {
            if (this._res != null) {
                this._errors.add(msg + " in " + this._res + "\n");
            } else {
                this._errors.add(msg + "\n");
            }
        }

        public void warning(SAXParseException ex) {
            Message.warn("xml parsing: " + this.getLocationString(ex) + ": " + ex.getMessage());
        }

        public void error(SAXParseException ex) {
            this.addError("xml parsing: " + this.getLocationString(ex) + ": " + ex.getMessage());
        }

        public void fatalError(SAXParseException ex) throws SAXException {
            this.addError("[Fatal Error] " + this.getLocationString(ex) + ": " + ex.getMessage());
        }

        private String getLocationString(SAXParseException ex) {
            StringBuffer str = new StringBuffer();
            String systemId = ex.getSystemId();
            if (systemId != null) {
                int index = systemId.lastIndexOf(47);
                if (index != -1) {
                    systemId = systemId.substring(index + 1);
                }
                str.append(systemId);
            } else if (this.getResource() != null) {
                str.append(this.getResource().toString());
            }
            str.append(':');
            str.append(ex.getLineNumber());
            str.append(':');
            str.append(ex.getColumnNumber());
            return str.toString();
        }

        protected String getDefaultConf() {
            return this._defaultConfMapping != null ? this._defaultConfMapping : (this._defaultConf != null ? this._defaultConf : DEFAULT_CONF_MAPPING);
        }

        protected void setDefaultConf(String defaultConf) {
            this._defaultConf = defaultConf;
        }

        public ModuleDescriptor getModuleDescriptor() throws ParseException {
            this.checkErrors();
            return this._md;
        }

        protected Date getDefaultPubDate() {
            return new Date(this._md.getLastModified());
        }

        protected long getLastModified() {
            long last = this.getResource().getLastModified();
            if (last > 0L) {
                return last;
            }
            Message.debug("impossible to get date for " + this.getResource() + ": using 'now'");
            return System.currentTimeMillis();
        }
    }
}

