// Code generated by bpf2go; DO NOT EDIT.
//go:build arm64

package pyrobpf

import (
	"bytes"
	_ "embed"
	"fmt"
	"io"

	"github.com/cilium/ebpf"
)

type ProfileGlobalConfigT struct{ NsPidIno uint64 }

type ProfilePidConfig struct {
	Type          uint8
	CollectUser   uint8
	CollectKernel uint8
	Padding       uint8
}

type ProfilePidEvent struct {
	Op  uint32
	Pid uint32
}

type ProfileSampleKey struct {
	Pid       uint32
	Flags     uint32
	KernStack int64
	UserStack int64
}

// LoadProfile returns the embedded CollectionSpec for Profile.
func LoadProfile() (*ebpf.CollectionSpec, error) {
	reader := bytes.NewReader(_ProfileBytes)
	spec, err := ebpf.LoadCollectionSpecFromReader(reader)
	if err != nil {
		return nil, fmt.Errorf("can't load Profile: %w", err)
	}

	return spec, err
}

// LoadProfileObjects loads Profile and converts it into a struct.
//
// The following types are suitable as obj argument:
//
//	*ProfileObjects
//	*ProfilePrograms
//	*ProfileMaps
//
// See ebpf.CollectionSpec.LoadAndAssign documentation for details.
func LoadProfileObjects(obj interface{}, opts *ebpf.CollectionOptions) error {
	spec, err := LoadProfile()
	if err != nil {
		return err
	}

	return spec.LoadAndAssign(obj, opts)
}

// ProfileSpecs contains maps and programs before they are loaded into the kernel.
//
// It can be passed ebpf.CollectionSpec.Assign.
type ProfileSpecs struct {
	ProfileProgramSpecs
	ProfileMapSpecs
	ProfileVariableSpecs
}

// ProfileProgramSpecs contains programs before they are loaded into the kernel.
//
// It can be passed ebpf.CollectionSpec.Assign.
type ProfileProgramSpecs struct {
	DisassociateCtty *ebpf.ProgramSpec `ebpf:"disassociate_ctty"`
	DoPerfEvent      *ebpf.ProgramSpec `ebpf:"do_perf_event"`
	Exec             *ebpf.ProgramSpec `ebpf:"exec"`
}

// ProfileMapSpecs contains maps before they are loaded into the kernel.
//
// It can be passed ebpf.CollectionSpec.Assign.
type ProfileMapSpecs struct {
	Counts *ebpf.MapSpec `ebpf:"counts"`
	Events *ebpf.MapSpec `ebpf:"events"`
	Pids   *ebpf.MapSpec `ebpf:"pids"`
	Progs  *ebpf.MapSpec `ebpf:"progs"`
	Stacks *ebpf.MapSpec `ebpf:"stacks"`
}

// ProfileVariableSpecs contains global variables before they are loaded into the kernel.
//
// It can be passed ebpf.CollectionSpec.Assign.
type ProfileVariableSpecs struct {
	E__          *ebpf.VariableSpec `ebpf:"e__"`
	GlobalConfig *ebpf.VariableSpec `ebpf:"global_config"`
}

// ProfileObjects contains all objects after they have been loaded into the kernel.
//
// It can be passed to LoadProfileObjects or ebpf.CollectionSpec.LoadAndAssign.
type ProfileObjects struct {
	ProfilePrograms
	ProfileMaps
	ProfileVariables
}

func (o *ProfileObjects) Close() error {
	return _ProfileClose(
		&o.ProfilePrograms,
		&o.ProfileMaps,
	)
}

// ProfileMaps contains all maps after they have been loaded into the kernel.
//
// It can be passed to LoadProfileObjects or ebpf.CollectionSpec.LoadAndAssign.
type ProfileMaps struct {
	Counts *ebpf.Map `ebpf:"counts"`
	Events *ebpf.Map `ebpf:"events"`
	Pids   *ebpf.Map `ebpf:"pids"`
	Progs  *ebpf.Map `ebpf:"progs"`
	Stacks *ebpf.Map `ebpf:"stacks"`
}

func (m *ProfileMaps) Close() error {
	return _ProfileClose(
		m.Counts,
		m.Events,
		m.Pids,
		m.Progs,
		m.Stacks,
	)
}

// ProfileVariables contains all global variables after they have been loaded into the kernel.
//
// It can be passed to LoadProfileObjects or ebpf.CollectionSpec.LoadAndAssign.
type ProfileVariables struct {
	E__          *ebpf.Variable `ebpf:"e__"`
	GlobalConfig *ebpf.Variable `ebpf:"global_config"`
}

// ProfilePrograms contains all programs after they have been loaded into the kernel.
//
// It can be passed to LoadProfileObjects or ebpf.CollectionSpec.LoadAndAssign.
type ProfilePrograms struct {
	DisassociateCtty *ebpf.Program `ebpf:"disassociate_ctty"`
	DoPerfEvent      *ebpf.Program `ebpf:"do_perf_event"`
	Exec             *ebpf.Program `ebpf:"exec"`
}

func (p *ProfilePrograms) Close() error {
	return _ProfileClose(
		p.DisassociateCtty,
		p.DoPerfEvent,
		p.Exec,
	)
}

func _ProfileClose(closers ...io.Closer) error {
	for _, closer := range closers {
		if err := closer.Close(); err != nil {
			return err
		}
	}
	return nil
}

// Do not access this directly.
//
//go:embed profile_arm64_bpfel.o
var _ProfileBytes []byte
