// Code generated by bpf2go; DO NOT EDIT.
//go:build arm64

package watcher

import (
	"bytes"
	_ "embed"
	"fmt"
	"io"

	"github.com/cilium/ebpf"
)

type bpf_debugWatchInfoT struct {
	Flags   uint64
	Payload uint64
}

// loadBpf_debug returns the embedded CollectionSpec for bpf_debug.
func loadBpf_debug() (*ebpf.CollectionSpec, error) {
	reader := bytes.NewReader(_Bpf_debugBytes)
	spec, err := ebpf.LoadCollectionSpecFromReader(reader)
	if err != nil {
		return nil, fmt.Errorf("can't load bpf_debug: %w", err)
	}

	return spec, err
}

// loadBpf_debugObjects loads bpf_debug and converts it into a struct.
//
// The following types are suitable as obj argument:
//
//	*bpf_debugObjects
//	*bpf_debugPrograms
//	*bpf_debugMaps
//
// See ebpf.CollectionSpec.LoadAndAssign documentation for details.
func loadBpf_debugObjects(obj interface{}, opts *ebpf.CollectionOptions) error {
	spec, err := loadBpf_debug()
	if err != nil {
		return err
	}

	return spec.LoadAndAssign(obj, opts)
}

// bpf_debugSpecs contains maps and programs before they are loaded into the kernel.
//
// It can be passed ebpf.CollectionSpec.Assign.
type bpf_debugSpecs struct {
	bpf_debugProgramSpecs
	bpf_debugMapSpecs
	bpf_debugVariableSpecs
}

// bpf_debugProgramSpecs contains programs before they are loaded into the kernel.
//
// It can be passed ebpf.CollectionSpec.Assign.
type bpf_debugProgramSpecs struct {
	BeylaKprobeSysBind *ebpf.ProgramSpec `ebpf:"beyla_kprobe_sys_bind"`
}

// bpf_debugMapSpecs contains maps before they are loaded into the kernel.
//
// It can be passed ebpf.CollectionSpec.Assign.
type bpf_debugMapSpecs struct {
	DebugEvents *ebpf.MapSpec `ebpf:"debug_events"`
	WatchEvents *ebpf.MapSpec `ebpf:"watch_events"`
}

// bpf_debugVariableSpecs contains global variables before they are loaded into the kernel.
//
// It can be passed ebpf.CollectionSpec.Assign.
type bpf_debugVariableSpecs struct {
	Ip4ip6Prefix *ebpf.VariableSpec `ebpf:"ip4ip6_prefix"`
	Unused       *ebpf.VariableSpec `ebpf:"unused"`
	Unused2      *ebpf.VariableSpec `ebpf:"unused_2"`
	UnusedHttp2  *ebpf.VariableSpec `ebpf:"unused_http2"`
}

// bpf_debugObjects contains all objects after they have been loaded into the kernel.
//
// It can be passed to loadBpf_debugObjects or ebpf.CollectionSpec.LoadAndAssign.
type bpf_debugObjects struct {
	bpf_debugPrograms
	bpf_debugMaps
	bpf_debugVariables
}

func (o *bpf_debugObjects) Close() error {
	return _Bpf_debugClose(
		&o.bpf_debugPrograms,
		&o.bpf_debugMaps,
	)
}

// bpf_debugMaps contains all maps after they have been loaded into the kernel.
//
// It can be passed to loadBpf_debugObjects or ebpf.CollectionSpec.LoadAndAssign.
type bpf_debugMaps struct {
	DebugEvents *ebpf.Map `ebpf:"debug_events"`
	WatchEvents *ebpf.Map `ebpf:"watch_events"`
}

func (m *bpf_debugMaps) Close() error {
	return _Bpf_debugClose(
		m.DebugEvents,
		m.WatchEvents,
	)
}

// bpf_debugVariables contains all global variables after they have been loaded into the kernel.
//
// It can be passed to loadBpf_debugObjects or ebpf.CollectionSpec.LoadAndAssign.
type bpf_debugVariables struct {
	Ip4ip6Prefix *ebpf.Variable `ebpf:"ip4ip6_prefix"`
	Unused       *ebpf.Variable `ebpf:"unused"`
	Unused2      *ebpf.Variable `ebpf:"unused_2"`
	UnusedHttp2  *ebpf.Variable `ebpf:"unused_http2"`
}

// bpf_debugPrograms contains all programs after they have been loaded into the kernel.
//
// It can be passed to loadBpf_debugObjects or ebpf.CollectionSpec.LoadAndAssign.
type bpf_debugPrograms struct {
	BeylaKprobeSysBind *ebpf.Program `ebpf:"beyla_kprobe_sys_bind"`
}

func (p *bpf_debugPrograms) Close() error {
	return _Bpf_debugClose(
		p.BeylaKprobeSysBind,
	)
}

func _Bpf_debugClose(closers ...io.Closer) error {
	for _, closer := range closers {
		if err := closer.Close(); err != nil {
			return err
		}
	}
	return nil
}

// Do not access this directly.
//
//go:embed bpf_debug_arm64_bpfel.o
var _Bpf_debugBytes []byte
