// Unless explicitly stated otherwise all files in this repository are licensed under the Apache-2.0 License.
// This product includes software developed at Datadog (https://www.datadoghq.com/).
// Copyright 2019-Present Datadog, Inc.

package datadogV2

import (
	"fmt"

	"github.com/DataDog/datadog-api-client-go/v2/api/datadog"
)

// VulnerabilityDependencyLocations Static library vulnerability location.
type VulnerabilityDependencyLocations struct {
	// Static library vulnerability location.
	Block DependencyLocation `json:"block"`
	// Static library vulnerability location.
	Name *DependencyLocation `json:"name,omitempty"`
	// Static library vulnerability location.
	Version *DependencyLocation `json:"version,omitempty"`
	// UnparsedObject contains the raw value of the object if there was an error when deserializing into the struct
	UnparsedObject       map[string]interface{} `json:"-"`
	AdditionalProperties map[string]interface{} `json:"-"`
}

// NewVulnerabilityDependencyLocations instantiates a new VulnerabilityDependencyLocations object.
// This constructor will assign default values to properties that have it defined,
// and makes sure properties required by API are set, but the set of arguments
// will change when the set of required properties is changed.
func NewVulnerabilityDependencyLocations(block DependencyLocation) *VulnerabilityDependencyLocations {
	this := VulnerabilityDependencyLocations{}
	this.Block = block
	return &this
}

// NewVulnerabilityDependencyLocationsWithDefaults instantiates a new VulnerabilityDependencyLocations object.
// This constructor will only assign default values to properties that have it defined,
// but it doesn't guarantee that properties required by API are set.
func NewVulnerabilityDependencyLocationsWithDefaults() *VulnerabilityDependencyLocations {
	this := VulnerabilityDependencyLocations{}
	return &this
}

// GetBlock returns the Block field value.
func (o *VulnerabilityDependencyLocations) GetBlock() DependencyLocation {
	if o == nil {
		var ret DependencyLocation
		return ret
	}
	return o.Block
}

// GetBlockOk returns a tuple with the Block field value
// and a boolean to check if the value has been set.
func (o *VulnerabilityDependencyLocations) GetBlockOk() (*DependencyLocation, bool) {
	if o == nil {
		return nil, false
	}
	return &o.Block, true
}

// SetBlock sets field value.
func (o *VulnerabilityDependencyLocations) SetBlock(v DependencyLocation) {
	o.Block = v
}

// GetName returns the Name field value if set, zero value otherwise.
func (o *VulnerabilityDependencyLocations) GetName() DependencyLocation {
	if o == nil || o.Name == nil {
		var ret DependencyLocation
		return ret
	}
	return *o.Name
}

// GetNameOk returns a tuple with the Name field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *VulnerabilityDependencyLocations) GetNameOk() (*DependencyLocation, bool) {
	if o == nil || o.Name == nil {
		return nil, false
	}
	return o.Name, true
}

// HasName returns a boolean if a field has been set.
func (o *VulnerabilityDependencyLocations) HasName() bool {
	return o != nil && o.Name != nil
}

// SetName gets a reference to the given DependencyLocation and assigns it to the Name field.
func (o *VulnerabilityDependencyLocations) SetName(v DependencyLocation) {
	o.Name = &v
}

// GetVersion returns the Version field value if set, zero value otherwise.
func (o *VulnerabilityDependencyLocations) GetVersion() DependencyLocation {
	if o == nil || o.Version == nil {
		var ret DependencyLocation
		return ret
	}
	return *o.Version
}

// GetVersionOk returns a tuple with the Version field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *VulnerabilityDependencyLocations) GetVersionOk() (*DependencyLocation, bool) {
	if o == nil || o.Version == nil {
		return nil, false
	}
	return o.Version, true
}

// HasVersion returns a boolean if a field has been set.
func (o *VulnerabilityDependencyLocations) HasVersion() bool {
	return o != nil && o.Version != nil
}

// SetVersion gets a reference to the given DependencyLocation and assigns it to the Version field.
func (o *VulnerabilityDependencyLocations) SetVersion(v DependencyLocation) {
	o.Version = &v
}

// MarshalJSON serializes the struct using spec logic.
func (o VulnerabilityDependencyLocations) MarshalJSON() ([]byte, error) {
	toSerialize := map[string]interface{}{}
	if o.UnparsedObject != nil {
		return datadog.Marshal(o.UnparsedObject)
	}
	toSerialize["block"] = o.Block
	if o.Name != nil {
		toSerialize["name"] = o.Name
	}
	if o.Version != nil {
		toSerialize["version"] = o.Version
	}

	for key, value := range o.AdditionalProperties {
		toSerialize[key] = value
	}
	return datadog.Marshal(toSerialize)
}

// UnmarshalJSON deserializes the given payload.
func (o *VulnerabilityDependencyLocations) UnmarshalJSON(bytes []byte) (err error) {
	all := struct {
		Block   *DependencyLocation `json:"block"`
		Name    *DependencyLocation `json:"name,omitempty"`
		Version *DependencyLocation `json:"version,omitempty"`
	}{}
	if err = datadog.Unmarshal(bytes, &all); err != nil {
		return datadog.Unmarshal(bytes, &o.UnparsedObject)
	}
	if all.Block == nil {
		return fmt.Errorf("required field block missing")
	}
	additionalProperties := make(map[string]interface{})
	if err = datadog.Unmarshal(bytes, &additionalProperties); err == nil {
		datadog.DeleteKeys(additionalProperties, &[]string{"block", "name", "version"})
	} else {
		return err
	}

	hasInvalidField := false
	if all.Block.UnparsedObject != nil && o.UnparsedObject == nil {
		hasInvalidField = true
	}
	o.Block = *all.Block
	if all.Name != nil && all.Name.UnparsedObject != nil && o.UnparsedObject == nil {
		hasInvalidField = true
	}
	o.Name = all.Name
	if all.Version != nil && all.Version.UnparsedObject != nil && o.UnparsedObject == nil {
		hasInvalidField = true
	}
	o.Version = all.Version

	if len(additionalProperties) > 0 {
		o.AdditionalProperties = additionalProperties
	}

	if hasInvalidField {
		return datadog.Unmarshal(bytes, &o.UnparsedObject)
	}

	return nil
}
