/**
 * The `String` namespace holds functions that are helpful when working with
 * text content strings in a rich text editor.
 */
declare namespace String {
    /**
     * Check if a character is a word character. The `remaining` argument is used
     * because sometimes you must read subsequent characters to truly determine it.
     */
    const isWordCharacter: (char: string, remaining: string) => boolean;
    /**
     * Get the distance to the end of the first character in a string of text.
     */
    const getCharacterDistance: (text: string) => number;
    /**
     * Get the distance to the end of the first word in a string of text.
     */
    const getWordDistance: (text: string) => number;
}
export { String };
//# sourceMappingURL=string.d.ts.map